<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\ControllerEvent;

use Dedi\SyliusMarketingPlugin\DTO\SelectItemDTO;
use Dedi\SyliusMarketingPlugin\Events\AbstractEvent;
use Dedi\SyliusMarketingPlugin\Events\Traits\JsonSerialize;

class SelectItemEvent extends AbstractEvent
{
    use JsonSerialize;

    public const NAME = 'controller_select_item';

    public int $productId;

    public ?int $productPosition = null;

    public function getName(): string
    {
        return self::NAME;
    }

    public function __construct(SelectItemDTO $selectItemDTO)
    {
        $this->productId = $selectItemDTO->id;
        $this->productPosition = $selectItemDTO->position;
    }
}
