<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\Controller;

use Dedi\SyliusMarketingPlugin\ControllerEvent\SelectItemEvent;
use Dedi\SyliusMarketingPlugin\DTO\SelectItemDTO;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;

class SelectItemController extends AbstractController
{
    public function ajaxSelectItem(Request $request, DenormalizerInterface $denormalizer, EventDispatcherInterface $eventDispatcher): Response
    {
        /** @var SelectItemDTO $selectItemDTO */
        $selectItemDTO = $denormalizer->denormalize(
            json_decode($request->getContent(), true, 512, \JSON_THROW_ON_ERROR),
            SelectItemDTO::class,
        );
        $eventDispatcher->dispatch(new SelectItemEvent($selectItemDTO), SelectItemEvent::NAME);

        return new Response('', Response::HTTP_OK);
    }
}
