<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\Controller;

use Dedi\Contracts\SyliusPluginSettings\SettingsProviderInterface;
use Dedi\SyliusMarketingPlugin\DependencyInjection\Settings\SettingsInterface;
use Dedi\SyliusMarketingPlugin\Events\EventInterface;
use Dedi\SyliusMarketingPlugin\Storage\EventStorageInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

class FetchEventController extends AbstractController
{
    private SettingsProviderInterface $settingsProvider;

    private EventStorageInterface $eventStorage;

    public function __construct(
        SettingsProviderInterface $settingsProvider,
        EventStorageInterface $eventStorage,
    ) {
        $this->settingsProvider = $settingsProvider;
        $this->eventStorage = $eventStorage;
    }

    public function fetch(Request $request): JsonResponse
    {
        /** @var SettingsInterface $settings */
        $settings = $this->settingsProvider->provide();
        $eventName = $request->request->get('dedi_sylius_marketing_async_event', '');
        $events = array_filter($this->eventStorage->getAsyncEvents(), static fn (EventInterface $event) => $event->getName() === $eventName);

        if (!$settings->isAsyncReloaded()) {
            /**
             * @var string $key
             * @var EventInterface $event
             */
            foreach ($events as $key => $event) {
                $this->eventStorage->removeAsyncEvent($key);
            }
        }

        return $this->json($events);
    }
}
