```php
<?php

namespace App\Marketing;

use Dedi\SyliusMarketingPlugin\Extractor\RequestProductExtractorInterface;
use MonsieurBiz\SyliusSearchPlugin\Context\TaxonContextInterface;
use MonsieurBiz\SyliusSearchPlugin\Model\Config\GridConfig;
use MonsieurBiz\SyliusSearchPlugin\Model\Document\Index\Search;
use MonsieurBiz\SyliusSearchPlugin\Model\Document\Result;
use Sylius\Component\Product\Repository\ProductRepositoryInterface;
use Symfony\Component\HttpKernel\Event\ControllerArgumentsEvent;
use Symfony\Contracts\EventDispatcher\Event;

class RequestProductMonsieurBizExtractor implements RequestProductExtractorInterface
{
    public function __construct(
        private readonly GridConfig $gridConfig,
        private readonly TaxonContextInterface $taxonContext,
        private readonly Search $documentSearch,
        private readonly ProductRepositoryInterface $productRepository
    )
    {
    }

    public function extract(Event $event): array
    {
        if (!$event instanceof ControllerArgumentsEvent) {
            return [];
        }

        $request = $event->getRequest();

        $this->gridConfig->init(GridConfig::TAXON_TYPE, $request, $this->taxonContext->getTaxon());
        $resultSet = $this->documentSearch->taxon($this->gridConfig);
        $results = $resultSet->getResults();

        $products = [];

        /** @var Result $result */
        foreach ($results as $result) {
           $product = $this->productRepository->findOneBy([
                'code' => $result->getCode(),
            ]);

            if ($product instanceof ProductInterface) {
                $products[] = $product;
            }
        }

        return $products;
    }
}
```