# Configuration Reference

## Available Configuration Options

### enabled

- type: `boolean`
- default: `true`

Enable or disable the plugin.

### marketing_id

- type: `string`
- default: `null`

The default Google Tag Manager ID to use for the datalayer

### channel_ids

- type: `array<channel_code, google_tag_manager_id>`
- default: `[]`

An array of Google Tag Manager IDs to use for specific channel codes. When the current channel code matches one of the key of `channel_ids`, the corresponding GTM ID overrides `marketing_id`.

```yaml
dedi_sylius_marketing:
    marketing_id: GTM-XXXX
    channel_ids:
        my_channel_foo: GTM-YYYY
        my_channel_bar: GTM-ZZZZ
```

### additional_parameters

- type: `string`
- default: `''`

**Note : does not seems to be used in the code.**

Additional parameters to add to the datalayer. This is a string that will be added to the datalayer as is.

### async_triggers

- type: `array<array<action: string, selector: string, event: string>>`
- default: `[]`

An array of triggers to use for the async loading of the GTM script. Each trigger is an array with the following keys:
* action: `string` - The javascript action that will trigger the loading of events
* selector: `string` - The CSS selector on wich to listen to the event
* event: `string` - The datalayer event to fetch and push to the datalayer

```yaml
dedi_sylius_marketing:
    async_triggers:
        - { action: 'click', selector: '.quick-add-to-cart', event: 'add_to_cart' }
```

With this configuration, the plugin will know that the `add_to_cart` is asynchronous. When the javascript event `click` is triggered on an element with the class `quick-add-to-cart`, the plugin will make an ajax call to the server to fetch any datalayer event named `add_to_cart` and push it to the datalayer.

### async_reloaded

- type: `boolean`
- default: `false`

If this option is set to `true`, the plugin will ensure that any async event is also fired on the next page load. This is to ensure that the event is always pushed to the datalayer, even if the user navigates away from the page before the ajax call is completed.

_Warning : This option will duplicate any async event on the next page load. This can lead to duplicate events in the datalayer. Use the unique `event_id` provided within the event to avoid duplicates in Google Tag Manager and Google Analytics._

### async_config

- type: `array<timeout: int, retries: int>`
- default: `{ timeout: 1000, retries: 5 }`

An array of configuration options for the async loading of the GTM script. The following keys are available:
* timeout: `int` - The time in millisecond that the plugin will wait before retrying to load events from the server
* retries: `int` - The number of retries before the async loading stops calling the server

As soon as the trigger is fired, the plugin will make an ajax call to the server to fetch the matching datalayer events. The plugin will retry the request `retries` times until the server returns some events and wait `timeout` milliseconds between each retry. This is to ensure that the datalayer events are always pushed to the datalayer, even if the server is slow to respond or if the request that trigger the datalayer event takes some time to be handled by the server (eg: an add to cart call).

### Full Configuration Example

```yaml
dedi_sylius_marketing:
    enabled: true
    marketing_id: GTM-XXXX
    channel_ids:
        my_channel_foo: GTM-YYYY
        my_channel_bar: GTM-ZZZZ
    additional_parameters: ''
    async_triggers:
        - { action: 'click', selector: '.quick-add-to-cart', event: 'add_to_cart' }
    async_reloaded: false
    async_config:
        timeout: 1000
        retries: 5
```


