# Marketing Plugin for Sylius by Dedi

The objective of this plugin is to centralize the marketing strategy through the dynamic creation of data layers and the management of SEO content.

## Quickstart Installation

```bash
$ make start
$ make install
$ make configure
```

## Installation

Run `composer require dedi/sylius-marketing-plugin`

Change your `config/bundles.php` file to add the line for the plugin :

```php
<?php

return [
    //..
    Dedi\SyliusMarketingPlugin\DediSyliusMarketingPlugin::class => ['all' => true],
];
```

Create `dedi_sylius_marketing_plugin.yaml` file into `config/packages` folder to import required config

```yaml
# config/packages/dedi_sylius_marketing_plugin.yaml

imports:
  - { resource: "@DediSyliusMarketingPlugin/Resources/config/config.yaml" }

dedi_sylius_marketing:
  enabled: true

services:
  _defaults:
    autowire: true
    autoconfigure: true
    public: false
```

Register SelectItemController in config file (services/marketing.yaml per exemple)

```yaml
# config/services/marketing.yaml

services:
  Dedi\SyliusMarketingPlugin\Controller\SelectItemController:
    tags: [ 'controller.service_arguments' ]
```

Create `dedi_sylius_marketing_plugin.yaml` file into `config/routes` folder to import required routes config

```yaml
# config/routes/dedi_sylius_marketing_plugin.yaml

dedi_marketing_shop:
  resource: "@DediSyliusMarketingPlugin/Resources/config/shop_routing.yml"
```

Configure Webpack to compile assets

```yaml
# config/packages/assets.yaml
framework:
    assets:
        packages:
            ...
            marketing_shop:
                json_manifest_path: '%kernel.project_dir%/public/build/dedi-plugin/marketing/shop/manifest.json'
```

```yaml
# config/packages/webpack_encore.yaml

    +
    1
    −
    0

    Viewed
webpack_encore:
    builds:
        ...
        marketing_shop: '%kernel.project_dir%/public/build/dedi-plugin/marketing/shop'
```

```javascript
// webpack.config.js

const path = require('path');
const Encore = require('@symfony/webpack-encore');
...
const [dediMarketingShop] = require('./vendor/dedi/sylius-marketing-plugin/webpack.config');

...

module.exports = [..., dediMarketingShop];
```

Add Google Tag Manager using the `get_google_tag_id` function in your layout to retrieve the GTM ID from the configuration file.

```html
{# templates/bundles/SyliusShopBundle/layout.html.twig #}
<!DOCTYPE html>

<html>
<head>
    <!-- Google Tag Manager -->
    <script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
                new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
            j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
            'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
    })(window,document,'script','dataLayer','{{ get_google_tag_id() }}');</script>
    <!-- End Google Tag Manager -->

...

</head>

<body class="pushable">
<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id={{ get_google_tag_id() }}"
                  height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->

...
</body>
```



To display datalayers, add following blocks in your layout 
```html
{# templates/bundles/SyliusShopBundle/layout.html.twig #}
<!DOCTYPE html>

<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    {% block datalayer %}
        {{ sylius_template_event('dedi_sylius_marketing_plugin.datalayer') }}
    {% endblock %}

    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
</head>
<body>
...
{% block javascripts %}
    ...
    {{ sylius_template_event('dedi_sylius_marketing_plugin.shop.select_item.javascripts') }}
{% endblock %}
</body>
</html>
```

## Custom Datalayers

### SelectItem

Add two attributes to items that will trigger selectItem datalayer :
- `data-select-item` attribute containing product id
- `data-item-position` attribute containing product position in the listing

### Newsletter

To add custom trigger for newsletter datalayer, override `src/EventListener/NewsletterEventListener.php` file.

## Implementation with MonsieurBiz

MonsieurBizSearchPlugin does not use sylius sonata event to render products and it uses specific components to retrieve data from elasticsearch. 
In order to generate `view_item_list` dataLayer with MonsieurBizSearchPlugin, you can make following implementation of `RequestProductExtractorInterface`.
```yaml

dedi_sylius_marketing:
  dedi_sylius_marketing.extractor.request_product:
    class: App\Marketing\Extractor\RequestProductMonsieurBizExtractor
```

See implemention here : [MONSIEURBIZ_EXTRACTOR.md](docs/MONSIEURBIZ_EXTRACTOR.md).

You can also consult implementation for BitBagElasticSearch here: [BITBAG_ELASTIC_SEARCH_EXTRACTOR.md](docs/BITBAG_ELASTIC_SEARCH_EXTRACTOR.md). 


To learn more about available configuration keys, see [CONFIGURATION.md](docs/CONFIGURATION.md).
