<?php

declare(strict_types=1);

namespace Dedi\SyliusMaintenancePlugin\Model;

use Doctrine\ORM\Mapping as ORM;

trait ChannelTrait
{
    #[ORM\Column(name: 'maintenance_active', type: 'boolean', options: ['default' => 0])]
    private bool $maintenanceActive = false;

    #[ORM\Column(name: 'maintenance_ip_list', type: 'string', nullable: true)]
    private ?string $maintenanceIpList = null;

    public function isMaintenanceActive(): bool
    {
        return $this->maintenanceActive;
    }

    public function setMaintenanceActive(bool $maintenanceActive): void
    {
        $this->maintenanceActive = $maintenanceActive;
    }

    public function getMaintenanceIpList(): ?string
    {
        return $this->maintenanceIpList;
    }

    public function setMaintenanceIpList(?string $maintenanceIpList): void
    {
        $this->maintenanceIpList = $maintenanceIpList;
    }
}
