<?php

declare(strict_types=1);

namespace Dedi\SyliusMaintenancePlugin\DependencyInjection\Settings;

use Dedi\Contracts\SyliusPluginSettings\SettingsProviderInterface;
use Dedi\SyliusMaintenancePlugin\Model\ChannelInterface;
use Sylius\Component\Channel\Context\ChannelContextInterface;
use Sylius\Component\Core\Model\ChannelInterface as BaseChannelInterface;

class SettingsProvider implements SettingsProviderInterface
{
    public function __construct(
        private readonly SettingsInterface $settings,
        private readonly ChannelContextInterface $channelContext,
    ) {
    }

    public function provide(bool $default = false): SettingsInterface
    {
        if (!$this->settings->hasActive() || !$this->settings->hasIpList()) {
            /** @var ChannelInterface|BaseChannelInterface $channel */
            $channel = $this->channelContext->getChannel();

            if ($channel instanceof ChannelInterface) {
                if (!$this->settings->hasActive()) {
                    $this->settings->setActive($channel->isMaintenanceActive());
                }

                if (!$this->settings->hasIpList()) {
                    $this->settings->setIpList($channel->getMaintenanceIpList() ?? '');
                }
            }
        }

        return $this->settings;
    }

    public function getName(): string
    {
        return 'dedi_maintenance_plugin';
    }
}
