<?php

declare(strict_types=1);

namespace Dedi\SyliusMaintenancePlugin\DependencyInjection\Settings;

class Settings implements SettingsInterface
{
    public function __construct(
        private readonly bool $enabled,
        private ?bool $active = null,
        private ?string $ipList = null,
    ) {
    }

    public function isEnabled(): bool
    {
        return $this->enabled;
    }

    public function isActive(): bool
    {
        return $this->active ?? false;
    }

    public function hasActive(): bool
    {
        return null !== $this->active;
    }

    public function setActive(bool $active): SettingsInterface
    {
        if ($this->hasActive()) {
            throw new \RuntimeException('Active setting is immutable');
        }
        $this->active = $active;

        return $this;
    }

    public function getIpList(): string
    {
        return $this->ipList ?? '';
    }

    public function hasIpList(): bool
    {
        return null !== $this->ipList;
    }

    public function setIpList(string $ipList): SettingsInterface
    {
        if ($this->hasIpList()) {
            throw new \RuntimeException('IP list setting is immutable');
        }
        $this->ipList = $ipList;

        return $this;
    }
}
