# Installation

Run `composer require dedi/sylius-maintenance-plugin`

Add plugin class to your `config/bundles.php`:

```php
<?php
$bundles = [
    // ...
    Dedi\SyliusMaintenancePlugin\DediSyliusMaintenancePlugin::class => ['all' => true],
    // ...
];
```

# Basic Configuration

## Import routing

```yaml
# config/routes.yaml

dedi_sylius_maintenance_shop:
    resource: "@DediSyliusMaintenancePlugin/Resources/config/shop_routing.yaml"
    prefix: /{_locale}
    requirements:
        _locale: ^[a-z]{2}(?:_[A-Z]{2})?$
```

## Add the environment variables

```
.env

MAINTENANCE_ACTIVE=
MAINTENANCE_IP_LIST=
```

That's it ! The maintenance can now be activated via the .env variable !

# Advanced Configuration (using the Channel to manage the maintenance)

## Extend your `Channel` Entity and Interface

```php
<?php

namespace App\Entity;

use Dedi\SyliusMaintenancePlugin\Model\ChannelInterface as MaintenanceChannelInterface;
use Sylius\Component\Core\Model\ChannelInterface as BaseChannelInterface;

interface ChannelInterface extends BaseChannelInterface, MaintenanceChannelInterface
{
}
```

```php
<?php

namespace App\Entity;

use Dedi\SyliusMaintenancePlugin\Model\ChannelTrait;
use Sylius\Component\Core\Model\Channel as BaseChannel;

class Channel extends BaseChannel
{
    use ChannelTrait;
}
```

## Add configuration

```yaml
# config/packages/_sylius.yaml

sylius_channel:
    resources:
        channel:
            classes:
                model: App\Entity\Channel
                interface: App\Entity\ChannelInterface
```

## Create migration

Create migration with `bin/console doctrine:migration:diff`

The migration should look like this

```php
    public function getDescription(): string
    {
        return '';
    }

    public function up(Schema $schema): void
    {
        $this->addSql('ALTER TABLE sylius_channel ADD maintenance_active TINYINT(1) DEFAULT \'0\' NOT NULL, ADD maintenance_ip_list VARCHAR(255) DEFAULT NULL');
    }

    public function down(Schema $schema): void
    {
        $this->addSql('ALTER TABLE sylius_channel DROP maintenance_active, DROP maintenance_ip_list');
    }
```


## (Optionnal) Render the form in the admin

Register the channel Type Extension

```
services.xml
        <service id="Dedi\SyliusMaintenancePlugin\Form\Extension\ChannelTypeExtension">
            <tag name="form.type_extension" />
        </service>
```

This plugin uses the `sylius.admin.channel.form.second_column_content` UI Event to render the maintenance section of the Channel form

To enabled the maintenance section in the Channel form, you simply need to call the sylius_ui.yaml file in your config

```
# config/packages/dedi_sylius_maintenance.yaml

imports:
    - { resource: "@DediSyliusMaintenancePlugin/Resources/config/sylius_ui.yaml" }
```

If this event is not used in your app, you can use another event (eg: `sylius.admin.channel.update.form`) or you can render the fields manually

```twig
# templates/bundles/SyliusAdminBundle/Channel/_form.html.twig

...

<div class="ui hidden divider"></div>
<h4 class="ui top attached large header">{{ 'dedi_sylius_maintenance.maintenance'|trans }}</h4>
<div class="ui attached segment">
    {{ form_row(form.maintenanceActive) }}
    {{ form_row(form.maintenanceIpList) }}
    <div class="ui info message">
        <p>{{ 'dedi_sylius_maintenance.help'|trans }}</p>
    </div>
</div>

...
```
