<?php

declare(strict_types=1);

namespace Dedi\SyliusMailAdminPlugin\Repository;

use Dedi\SyliusMailAdminPlugin\Entity\MailInterface;
use Doctrine\ORM\NonUniqueResultException;

interface MailRepositoryInterface
{
    public function findByCode(string $code, ?int $excludedMailId = null): array;

    /** @throws NonUniqueResultException */
    public function findTranslatableByCode(string $code, string $locale): ?MailInterface;
}
