<?php

declare(strict_types=1);

namespace Dedi\SyliusMailAdminPlugin\Repository;

use Dedi\SyliusMailAdminPlugin\Entity\MailInterface;
use Doctrine\ORM\AbstractQuery;
use Doctrine\ORM\NonUniqueResultException;
use Doctrine\ORM\QueryBuilder;
use Sylius\Bundle\ResourceBundle\Doctrine\ORM\EntityRepository;

class MailRepository extends EntityRepository implements MailRepositoryInterface
{
    protected function createTranslationBasedQueryBuilder(?string $locale = null): QueryBuilder
    {
        $queryBuilder = $this->createQueryBuilder('o')
            ->addSelect('translation')
            ->innerJoin('o.translations', 'translation', 'WITH', 'translation.locale = :locale')
        ;

        if (null !== $locale) {
            $queryBuilder
                ->andWhere('translation.locale = :locale')
                ->setParameter('locale', $locale)
            ;
        }

        return $queryBuilder;
    }

    public function findByCode(string $code, ?int $excludedMailId = null): array
    {
        $builder = $this->createQueryBuilder('o');
        $builder
            ->andWhere('o.code = :code')
            ->setParameter('code', $code)
        ;

        if (null !== $excludedMailId) {
            $builder
                ->andWhere('o.id != :excludedId')
                ->setParameter('excludedId', $excludedMailId)
            ;
        }

        return $builder->getQuery()->getResult();
    }

    /** @throws NonUniqueResultException */
    public function findTranslatableByCode(string $code, string $locale): ?MailInterface
    {
        $builder = $this
            ->createTranslationBasedQueryBuilder($locale)
            ->andWhere('o.code = :code')
            ->setParameter('code', $code)
        ;

        return $builder->getQuery()->getOneOrNullResult(AbstractQuery::HYDRATE_OBJECT);
    }
}
