<?php

declare(strict_types=1);

namespace Dedi\SyliusMailAdminPlugin\Registry;

use Dedi\SyliusMailAdminPlugin\Exception\MailConfigurationNotFoundException;

interface MailConfigurationRegistryInterface
{
    public function addMailConfiguration(string $mailCode, array $variablesConfiguration): void;

    /**
     * @throws MailConfigurationNotFoundException
     */
    public function getConfigurationByMailCode(string $mailCode): MailConfiguration;
}
