<?php

declare(strict_types=1);

namespace Dedi\SyliusMailAdminPlugin\Registry;

use Dedi\SyliusMailAdminPlugin\Exception\MailConfigurationNotFoundException;
use Dedi\SyliusMailAdminPlugin\Factory\MailConfigurationFactoryInterface;

class MailConfigurationRegistry implements MailConfigurationRegistryInterface
{
    private array $mailDefinitions;

    public function __construct(private readonly MailConfigurationFactoryInterface $mailConfigurationFactory)
    {
        $this->mailDefinitions = [];
    }

    public function addMailConfiguration(string $mailCode, array $variablesConfiguration): void
    {
        $this->mailDefinitions[$mailCode] = $this->mailConfigurationFactory->createNewFromConfiguration($mailCode, $variablesConfiguration);
    }

    public function getConfigurationByMailCode(string $mailCode): MailConfiguration
    {
        if (!array_key_exists($mailCode, $this->mailDefinitions)) {
            throw new MailConfigurationNotFoundException(sprintf('No configuration found for mail with code "%s"', $mailCode));
        }

        return $this->mailDefinitions[$mailCode];
    }
}
