<?php

declare(strict_types=1);

namespace Dedi\SyliusMailAdminPlugin\Provider;

use Dedi\SyliusMailAdminPlugin\Entity\MailInterface;
use Dedi\SyliusMailAdminPlugin\Repository\MailRepositoryInterface;
use Doctrine\ORM\NonUniqueResultException;
use Sylius\Component\Locale\Context\LocaleContextInterface;
use Sylius\Component\Mailer\Factory\EmailFactoryInterface;
use Sylius\Component\Mailer\Model\EmailInterface;
use Sylius\Component\Mailer\Provider\EmailProviderInterface;

class CustomEmailProvider implements EmailProviderInterface
{
    public function __construct(
        private readonly EmailProviderInterface $decoratedProvider,
        private readonly EmailFactoryInterface $emailFactory,
        private readonly MailRepositoryInterface $mailRepository,
        private readonly LocaleContextInterface $localeContext,
    ) {
    }

    public function getEmail(string $code): EmailInterface
    {
        try {
            /** @var MailInterface $mail */
            $mail = $this->mailRepository->findTranslatableByCode($code, $this->localeContext->getLocaleCode());
        } catch (NonUniqueResultException $e) {
            $mail = null;
        }

        if (null === $mail) {
            return $this->decoratedProvider->getEmail($code);
        }

        $email = $this->emailFactory->createNew();

        $email->setCode($mail->getCode());
        $email->setSenderAddress($mail->getSenderAddress());
        $email->setSenderName($mail->getSenderName());
        $email->setSubject($mail->getSubject());
        $email->setContent($mail->getContent());
        $email->setEnabled($mail->isEnabled());

        return $email;
    }
}
