<?php

declare(strict_types=1);

namespace Dedi\SyliusMailAdminPlugin\Handler;

use Dedi\SyliusMailAdminPlugin\Event\MailPreRenderEvent;
use Sylius\Component\User\Model\UserInterface;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;
use Symfony\Component\Routing\RouterInterface;

class VerificationTokenHandler implements MailVariablesHandlerInterface
{
    public function __construct(private readonly RouterInterface $router)
    {
    }

    public function handle(MailPreRenderEvent $event): MailPreRenderEvent
    {
        $data = $event->getData();
        /** @var UserInterface $user */
        $user = $data['user'];

        $data['verificationUrl'] = $this->router->generate('sylius_shop_user_verification', [
            'token' => $user->getEmailVerificationToken(),
        ], UrlGeneratorInterface::ABSOLUTE_URL);

        $event->setData($data);

        return $event;
    }
}
