<?php

declare(strict_types=1);

namespace Dedi\SyliusMailAdminPlugin\Handler;

use Dedi\SyliusMailAdminPlugin\Event\MailPreRenderEvent;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;
use Symfony\Component\Routing\RouterInterface;

class UserRegistrationHandler implements MailVariablesHandlerInterface
{
    public function __construct(private readonly RouterInterface $router)
    {
    }

    public function handle(MailPreRenderEvent $event): MailPreRenderEvent
    {
        $data = $event->getData();

        $data['homepageUrl'] = $this->router->generate('sylius_shop_homepage', [], UrlGeneratorInterface::ABSOLUTE_URL);

        $event->setData($data);

        return $event;
    }
}
