<?php

declare(strict_types=1);

namespace Dedi\SyliusMailAdminPlugin\Handler;

use Dedi\SyliusMailAdminPlugin\Event\MailPreRenderEvent;
use Dedi\SyliusMailAdminPlugin\Factory\TrackingUrlFactoryInterface;
use Sylius\Component\Core\Model\OrderInterface;
use Sylius\Component\Core\Model\ShipmentInterface;
use Sylius\Component\Core\Model\ShippingMethodInterface;
use Webmozart\Assert\Assert;

class ShipmentConfirmationHandler implements MailVariablesHandlerInterface
{
    public function __construct(private readonly TrackingUrlFactoryInterface $trackingUrlFactory)
    {
    }

    public function handle(MailPreRenderEvent $event): MailPreRenderEvent
    {
        $data = $event->getData();

        /** @var OrderInterface|null $order */
        $order = array_key_exists('order', $data) ? $data['order'] : null;
        Assert::isInstanceOf($order, OrderInterface::class);

        /** @var ShipmentInterface|bool $shipment */
        $shipment = $order->getShipments()->first();
        Assert::isInstanceOf($shipment, ShipmentInterface::class);

        /** @var ShippingMethodInterface $method */
        $method = $shipment->getMethod();

        $data['tracking_url'] = $this->trackingUrlFactory->build($method, $shipment->getTracking());

        $event->setData($data);

        return $event;
    }
}
