<?php

declare(strict_types=1);

namespace Dedi\SyliusMailAdminPlugin\Handler;

use Dedi\SyliusMailAdminPlugin\Event\MailPreRenderEvent;
use Sylius\Component\User\Model\UserInterface;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;
use Symfony\Component\Routing\RouterInterface;

class ResetPasswordTokenHandler implements MailVariablesHandlerInterface
{
    public function __construct(private readonly RouterInterface $router)
    {
    }

    public function handle(MailPreRenderEvent $event): MailPreRenderEvent
    {
        $data = $event->getData();
        /** @var UserInterface $user */
        $user = $data['user'];

        $data['resetUrl'] = $this->router->generate('sylius_shop_password_reset', [
            'token' => $user->getPasswordResetToken(),
        ], UrlGeneratorInterface::ABSOLUTE_URL);

        $event->setData($data);

        return $event;
    }
}
