<?php

declare(strict_types=1);

namespace Dedi\SyliusMailAdminPlugin\Handler;

use Dedi\SyliusMailAdminPlugin\Event\MailPreRenderEvent;
use Sylius\Component\Core\Model\OrderInterface;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;
use Symfony\Component\Routing\RouterInterface;
use Twig\Environment;

class OrderConfirmationHandler implements MailVariablesHandlerInterface
{
    public function __construct(
        private readonly RouterInterface $router,
        private readonly Environment $environment,
    ) {
    }

    public function handle(MailPreRenderEvent $event): MailPreRenderEvent
    {
        $data = $event->getData();

        /** @var OrderInterface $order */
        $order = $data['order'];

        $data['orderUrl'] = $this->router->generate('sylius_shop_account_order_show', [
            'number' => $order->getNumber(),
        ], UrlGeneratorInterface::ABSOLUTE_URL);
        $data['order_items_table'] = $this->environment->render('@DediSyliusMailAdminPlugin/shared/mail/order/_items.html.twig', [
            'order' => $order,
        ]);
        $event->setData($data);

        return $event;
    }
}
