<?php

declare(strict_types=1);

namespace Dedi\SyliusMailAdminPlugin\Form\Type;

use Dedi\SyliusMailAdminPlugin\Entity\MailInterface;
use Dedi\SyliusMailAdminPlugin\Exception\MailConfigurationNotFoundException;
use Dedi\SyliusMailAdminPlugin\Registry\MailConfigurationRegistryInterface;
use Sylius\Bundle\ResourceBundle\Form\EventSubscriber\AddCodeFormSubscriber;
use Sylius\Bundle\ResourceBundle\Form\Type\AbstractResourceType;
use Sylius\Bundle\ResourceBundle\Form\Type\ResourceTranslationsType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormView;

class MailType extends AbstractResourceType
{
    private readonly MailConfigurationRegistryInterface $mailConfigurationRegistry;

    public function __construct(
        string $dataClass,
        MailConfigurationRegistryInterface $mailConfigurationRegistry,
        array $validationGroups = [],
    ) {
        parent::__construct($dataClass, $validationGroups);

        $this->mailConfigurationRegistry = $mailConfigurationRegistry;
    }

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        /** @var MailInterface $mail */
        $mail = $builder->getData();

        $builder
            ->addEventSubscriber(new AddCodeFormSubscriber())
            ->add('enabled', CheckboxType::class, [
                'label' => 'dedi_sylius_mail_admin_plugin.enabled',
            ])
            ->add('description', TextareaType::class, [
                'label' => 'dedi_sylius_mail_admin_plugin.description',
                'required' => false,
            ])
            ->add('translations', ResourceTranslationsType::class, [
                'entry_type' => MailTranslationType::class,
                'entry_options' => [
                    'mail_code' => $mail->getCode(),
                ],
            ])
        ;
    }

    public function buildView(FormView $view, FormInterface $form, array $options): void
    {
        /** @var MailInterface $mail */
        $mail = $form->getViewData();

        try {
            $view->vars['mail_variables'] = $this->mailConfigurationRegistry->getConfigurationByMailCode($mail->getCode())->getVariables();
        } catch (MailConfigurationNotFoundException $e) {
            $view->vars['mail_variables'] = [];
        }
    }
}
