<?php

declare(strict_types=1);

namespace Dedi\SyliusMailAdminPlugin\Form\Type;

use Dedi\SyliusMailAdminPlugin\Form\Constraints\AvailableVariables;
use Sylius\Bundle\ResourceBundle\Form\Type\AbstractResourceType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints\Email;
use Symfony\Component\Validator\Constraints\NotBlank;

class MailTranslationType extends AbstractResourceType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('senderAddress', EmailType::class, [
                'required' => true,
                'label' => 'dedi_sylius_mail_admin_plugin.email.sender_address',
                'constraints' => [
                    new NotBlank(['groups' => $this->validationGroups]),
                    new Email(['groups' => $this->validationGroups]),
                ],
            ])
            ->add('senderName', TextType::class, [
                'required' => false,
                'label' => 'dedi_sylius_mail_admin_plugin.email.sender_name',
            ])
            ->add('subject', TextType::class, [
                'required' => true,
                'label' => 'dedi_sylius_mail_admin_plugin.email.subject',
                'constraints' => [
                    new NotBlank(['groups' => $this->validationGroups]),
                ],
            ])
            ->add('content', TextareaType::class, [
                'required' => false,
                'label' => 'dedi_sylius_mail_admin_plugin.email.content',
                'constraints' => [
                    new AvailableVariables([
                        'groups' => $this->validationGroups,
                        'mailCode' => $options['mail_code'],
                    ]),
                ],
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        parent::configureOptions($resolver);

        $resolver
            ->setRequired('mail_code')
            ->setAllowedTypes('mail_code', 'string')
        ;
    }
}
