<?php

declare(strict_types=1);

namespace Dedi\SyliusMailAdminPlugin\Form\Constraints;

use Dedi\SyliusMailAdminPlugin\Checker\MailVariablesValidatorInterface;
use Dedi\SyliusMailAdminPlugin\Exception\UnexpectedMailVariablesException;
use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;
use Webmozart\Assert\Assert;

class AvailableVariablesValidator extends ConstraintValidator
{
    private readonly MailVariablesValidatorInterface $mailVariablesValidator;

    public function __construct(MailVariablesValidatorInterface $mailVariablesValidator)
    {
        $this->mailVariablesValidator = $mailVariablesValidator;
    }

    /**
     * @param Constraint|AvailableVariables $constraint
     */
    public function validate($value, Constraint $constraint): void
    {
        if (!is_string($value) || '' === $value) {
            return;
        }

        Assert::isInstanceOf($constraint, AvailableVariables::class);

        try {
            $this->mailVariablesValidator->validateMailVariables($constraint->mailCode, $value);
        } catch (UnexpectedMailVariablesException $e) {
            $this->context->addViolation($e->getMessage());
        }
    }
}
