<?php

declare(strict_types=1);

namespace Dedi\SyliusMailAdminPlugin\Fixtures;

use Doctrine\Persistence\ObjectManager;
use Sylius\Bundle\CoreBundle\Fixture\Factory\ExampleFactoryInterface;
use Sylius\Bundle\FixturesBundle\Fixture\FixtureInterface;
use Symfony\Component\Config\Definition\Builder\ArrayNodeDefinition;
use Symfony\Component\Config\Definition\Builder\TreeBuilder;

class MailFixtures implements FixtureInterface
{
    public function __construct(
        private readonly ObjectManager $objectManager,
        private readonly ExampleFactoryInterface $subjectFactory,
    ) {
    }

    public function getConfigTreeBuilder(): TreeBuilder
    {
        $treeBuilder = new TreeBuilder($this->getName());

        /** @var ArrayNodeDefinition $optionsNode */
        $optionsNode = $treeBuilder->getRootNode();

        $optionsNode
            ->children()
                ->booleanNode('enabled')->defaultTrue()->end()
                ->scalarNode('code')->cannotBeEmpty()->end()
                ->scalarNode('description')->cannotBeEmpty()->end()
                ->arrayNode('translations')
                        ->arrayPrototype()
                            ->children()
                                ->scalarNode('sender_address')->cannotBeEmpty()->end()
                                ->scalarNode('sender_name')->cannotBeEmpty()->end()
                                ->scalarNode('subject')->cannotBeEmpty()->end()
                                ->scalarNode('content')->cannotBeEmpty()->end()
                            ->end()
                        ->end()
                    ->end()
                ->end();

        return $treeBuilder;
    }

    public function load(array $options): void
    {
        $subject = $this->subjectFactory->create($options);
        $this->objectManager->persist($subject);
        $this->objectManager->flush();
    }

    public function getName(): string
    {
        return 'mail';
    }
}
