<?php

declare(strict_types=1);

namespace Dedi\SyliusMailAdminPlugin\Fixtures\Factory;

use Dedi\SyliusMailAdminPlugin\Entity\MailInterface;
use Sylius\Bundle\CoreBundle\Fixture\Factory\ExampleFactoryInterface;
use Sylius\Component\Locale\Context\LocaleContextInterface;
use Sylius\Component\Resource\Factory\FactoryInterface;

class Mail implements ExampleFactoryInterface
{
    public function __construct(
        private readonly FactoryInterface $mailFactory,
        private readonly FactoryInterface $mailTranslationFactory,
        private readonly LocaleContextInterface $localeContext,
    ) {
    }

    public function create(array $options = []): MailInterface
    {
        /** @var MailInterface|null $mail */
        $mail = $this->mailFactory->createNew();

        $mail->setCode($options['code']);
        $mail->setEnabled($options['enabled']);
        $mail->setDescription($options['description']);
        $mail->setCurrentLocale($this->localeContext->getLocaleCode());
        $mail->setFallbackLocale($this->localeContext->getLocaleCode());

        foreach ($options['translations'] as $localeCode => $translation) {
            $mailTranslation = $this->mailTranslationFactory->createNew();

            $mailTranslation->setLocale($localeCode);
            $mailTranslation->setSenderAddress($translation['sender_address']);
            $mailTranslation->setSenderName($translation['sender_name']);
            $mailTranslation->setSubject($translation['subject']);
            $mailTranslation->setContent($translation['content']);
            $mail->addTranslation($mailTranslation);
        }

        return $mail;
    }
}
