<?php

declare(strict_types=1);

namespace Dedi\SyliusMailAdminPlugin\Factory;

use Dedi\SyliusMailAdminPlugin\Registry\MailConfiguration;
use Dedi\SyliusMailAdminPlugin\Registry\MailConfigurationInterface;
use Dedi\SyliusMailAdminPlugin\Registry\MailVariable;

class MailConfigurationFactory implements MailConfigurationFactoryInterface
{
    public function createNewFromConfiguration(string $mailCode, array $variablesConfiguration): MailConfigurationInterface
    {
        $variables = array_map(static fn (string $name, array $variableDefinition) => new MailVariable($name, $variableDefinition['label']), array_keys($variablesConfiguration), array_values($variablesConfiguration));

        return new MailConfiguration($mailCode, $variables);
    }
}
