<?php

declare(strict_types=1);

namespace Dedi\SyliusMailAdminPlugin\EventListener;

use Sylius\Bundle\UiBundle\Menu\Event\MenuBuilderEvent;

class MailAdminMenuEventListener
{
    public function __invoke(MenuBuilderEvent $event)
    {
        $menu = $event->getMenu();
        $menu
            ->addChild('dedi_emailing_management')
            ->setLabel('dedi_sylius_mail_admin_plugin.email_management')
            ->setLabelAttribute('icon', 'tabler:at')
        ;

        $child = $menu->getChild('dedi_emailing_management');
        $child
            ->addChild('dedi_emailing_management_list', ['route' => 'dedi_sylius_mail_admin_plugin_admin_mail_index'])
            ->setLabel('dedi_sylius_mail_admin_plugin.emails')
        ;
    }
}
