<?php

declare(strict_types=1);

namespace Dedi\SyliusMailAdminPlugin\EventListener\Mail;

use Dedi\SyliusMailAdminPlugin\Event\MailPreRenderEvent;
use Dedi\SyliusMailAdminPlugin\Handler\MailVariablesHandlerInterface;

class MailPreRenderListener implements MailPreRenderListenerInterface
{
    /** @var array<string, MailVariablesHandlerInterface> */
    private iterable $mailVariableHandlers = [];

    public function addMailPreRenderListener(string $mailCode, MailVariablesHandlerInterface $mailVariablesHandler): void
    {
        $this->mailVariableHandlers[$mailCode] = $mailVariablesHandler;
    }

    public function onPreRender(MailPreRenderEvent $event): MailPreRenderEvent
    {
        $mailCode = $event->getEmail()->getCode();
        if (!array_key_exists($mailCode, $this->mailVariableHandlers)) {
            return $event;
        }

        return $this->mailVariableHandlers[$mailCode]->handle($event);
    }
}
