<?php

declare(strict_types=1);

namespace Dedi\SyliusMailAdminPlugin\Event;

use Sylius\Component\Mailer\Model\EmailInterface;
use Symfony\Contracts\EventDispatcher\Event;

class MailPreRenderEvent extends Event
{
    public function __construct(private EmailInterface $email, private array $data)
    {
    }

    public function getData(): array
    {
        return $this->data;
    }

    public function getEmail(): EmailInterface
    {
        return $this->email;
    }

    public function setData(array $data): self
    {
        $this->data = $data;

        return $this;
    }

    public function setEmail(EmailInterface $email): self
    {
        $this->email = $email;

        return $this;
    }
}
