<?php

declare(strict_types=1);

namespace Dedi\SyliusMailAdminPlugin\Entity;

use Doctrine\ORM\Mapping as ORM;
use Sylius\Component\Resource\Model\AbstractTranslation;
use Symfony\Component\Validator\Constraints as Assert;

#[ORM\Entity]
#[ORM\Table(name: 'dedi_sylius_mail_translation')]
class MailTranslation extends AbstractTranslation implements MailTranslationInterface
{
    #[ORM\Column(name: 'id', type: 'integer', nullable: false)]
    #[ORM\Id]
    #[ORM\GeneratedValue]
    protected ?int $id = null;

    #[ORM\Column(name: 'subject', type: 'string', nullable: false)]
    protected ?string $subject = null;

    #[ORM\Column(name: 'sender_address', type: 'string', nullable: false)]
    #[Assert\Email]
    protected ?string $senderAddress = null;

    #[ORM\Column(name: 'sender_name', type: 'string', nullable: true)]
    protected ?string $senderName = null;

    #[ORM\Column(name: 'content', type: 'text', nullable: true)]
    protected ?string $content = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getSubject(): ?string
    {
        return $this->subject;
    }

    public function setSubject(?string $subject): self
    {
        $this->subject = $subject;

        return $this;
    }

    public function getContent(): ?string
    {
        return $this->content;
    }

    public function setContent(?string $content): self
    {
        $this->content = $content;

        return $this;
    }

    public function getSenderAddress(): ?string
    {
        return $this->senderAddress;
    }

    public function setSenderAddress(?string $senderAddress): self
    {
        $this->senderAddress = $senderAddress;

        return $this;
    }

    public function getSenderName(): ?string
    {
        return $this->senderName;
    }

    public function setSenderName(?string $senderName): self
    {
        $this->senderName = $senderName;

        return $this;
    }
}
