<?php

declare(strict_types=1);

namespace Dedi\SyliusMailAdminPlugin\Entity;

use Sylius\Component\Resource\Model\CodeAwareInterface;
use Sylius\Component\Resource\Model\ResourceInterface;
use Sylius\Component\Resource\Model\TranslatableInterface;
use Sylius\Component\Resource\Model\TranslationInterface;

interface MailInterface extends ResourceInterface, TranslatableInterface, CodeAwareInterface
{
    public function getId(): ?int;

    public function isEnabled(): bool;

    public function setEnabled(bool $enabled): self;

    public function getDescription(): ?string;

    public function setDescription(?string $description): self;

    public function getSenderAddress(): string;

    public function getSenderName(): string;

    public function getSubject(): string;

    public function getContent(): string;

    /** @return MailTranslation */
    public function getTranslation(?string $locale = null): TranslationInterface;
}
