<?php

declare(strict_types=1);

namespace Dedi\SyliusMailAdminPlugin\Entity;

use Doctrine\ORM\Mapping as ORM;
use Sylius\Component\Resource\Model\TranslatableTrait;
use Sylius\Component\Resource\Model\TranslationInterface;
use Symfony\Component\Validator\Constraints as Assert;

#[ORM\Entity]
#[ORM\Table(name: 'dedi_sylius_mail')]
class Mail implements MailInterface
{
    use TranslatableTrait {
        __construct as private initializeTranslationsCollection;
    }

    #[ORM\Column(name: 'id', type: 'integer', nullable: false)]
    #[ORM\Id]
    #[ORM\GeneratedValue]
    protected ?int $id = null;

    #[ORM\Column(name: 'code', type: 'string', unique: true, nullable: false)]
    #[Assert\NotBlank]
    protected ?string $code = null;

    #[ORM\Column(name: 'description', type: 'string', nullable: true)]
    protected ?string $description = null;

    #[ORM\Column(name: 'enabled', type: 'boolean')]
    protected bool $enabled = true;

    public function __construct()
    {
        $this->initializeTranslationsCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getCode(): ?string
    {
        return $this->code;
    }

    public function setCode(?string $code): void
    {
        $this->code = $code;
    }

    public function isEnabled(): bool
    {
        return $this->enabled;
    }

    public function setEnabled(bool $enabled): self
    {
        $this->enabled = $enabled;

        return $this;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function setDescription(?string $description): self
    {
        $this->description = $description;

        return $this;
    }

    public function getSenderAddress(): string
    {
        /** @var MailTranslation $translation */
        $translation = $this->getTranslation();

        return $translation->getSenderAddress();
    }

    public function getSenderName(): string
    {
        /** @var MailTranslation $translation */
        $translation = $this->getTranslation();

        return (string) $translation->getSenderName();
    }

    public function getSubject(): string
    {
        /** @var MailTranslation $translation */
        $translation = $this->getTranslation();

        return $translation->getSubject();
    }

    public function getContent(): string
    {
        /** @var MailTranslation $translation */
        $translation = $this->getTranslation();

        return (string) $translation->getContent();
    }

    protected function createTranslation(): TranslationInterface
    {
        return new MailTranslation();
    }
}
