<?php

declare(strict_types=1);

namespace Dedi\SyliusMailAdminPlugin\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

final class Configuration implements ConfigurationInterface
{
    public function getConfigTreeBuilder(): TreeBuilder
    {
        $treeBuilder = new TreeBuilder('dedi_sylius_mail_admin_plugin');
        if (\method_exists($treeBuilder, 'getRootNode')) {
            $rootNode = $treeBuilder->getRootNode();
        } else {
            // BC layer for symfony/config 4.1 and older
            $rootNode = $treeBuilder->root('dedi_sylius_mail_admin_plugin');
        }

        $rootNode
            ->children()
                ->arrayNode('mails')
                    ->useAttributeAsKey('code')
                    ->arrayPrototype()
                        ->children()
                            ->scalarNode('mail_code')->end()
                            ->arrayNode('variables')
                                ->useAttributeAsKey('name')
                                ->arrayPrototype()
                                    ->children()
                                    ->scalarNode('variable_name')->end()
                                    ->scalarNode('label')->end()
                                ->end()
                            ->end()
                            ->end()
                        ->end()
                    ->end()
                ->end()
            ->end()
        ;

        return $treeBuilder;
    }
}
