## How it works

### The Provider

By default, Sylius will look into the `sylius_mailer.yaml` file for the emails. With the code, it will find the corresponding template, render it, and send the content.

This plugin aims to decorate this logic thanks to the `Dedi\SyliusMailAdminPlugin\Provider\CustomEmailProvider`.

This custom provider will first look in the database (with the `Dedi\SyliusMailAdminPlugin\Repository\MailRepository`) for email previously inserted inside the `dedi_sylius_mail` and `dedi_sylius_mail_translation` tables.

If found, an `Email` will be created, and hydrated thanks to the data stored in database. 

If **not** found, the default Sylius' `EmailProvider` is called.

### The Renderer

This plugin introduces the `Dedi\SyliusMailAdminPlugin\Renderer\Adapter\EmailTwigAdapter` class, which decorates Sylius' one.
That way, we can send the `MailPreRenderEvent` event before rendering the email, allowing us to call our corresponding handler.


## Adding your own handler

### Creating the service
To add a handler, first create a class in your project directory that implements the `Dedi\SyliusMailAdminPlugin\Handler\MailVariablesHandlerInterface` interface.

```php
<?php

declare(strict_types=1);

namespace MyProjet\Mail\Handler;


class MyCustomHandler implements MailVariablesHandlerInterface { 

    public function handle(MailPreRenderEvent $event): MailPreRenderEvent
    {
        // Implement your own logic
    }
}
```

Then, register this class for the desired email with the tag `mail_variables_handler` for the desired email simply by providing the `mail` parameters on the tag declaration, like this :

```xml
<service id="MyProject\Mail\Handler\MyCustomerHandler">
    ...
    <tag name="dedi_mail_admin.mail_variables_handler" mail="my_email_code"/>
</service>
```

If you want to use the same handler for multiple emails, simply add another tag, with a different email code :
```xml
<service id="MyProject\Mail\Handler\MyCustomerHandler">
    ...
    <tag name="dedi_mail_admin.mail_variables_handler" mail="my_email_code"/>
    <tag name="dedi_mail_admin.mail_variables_handler" mail="my_other_email_code"/>
</service>
```

That's it ! Your listener will now be called whenever the email `my_emal_code` will be sent.
