<p align="center">
    <a href="https://sylius.com" target="_blank">
        <img src="https://demo.sylius.com/assets/shop/img/logo.png" />
    </a>
</p>

<p align="center">
    <a href="https://sylius.com" target="_blank">
        <img src="https://www.dedi-agency.com/wp-content/uploads/2014/05/Dedi_logo_HD.png" />
    </a>
</p>

<h1 align="center">Mail Admin Plugin</h1>

<p align="center">Plugin that allows the customisation of the emails directly from the admin panel.</p>

# Installation

### Require the plugin with composer :

```bash
composer require dedi/sylius-mail-admin-plugin
```

### Configure your emails like the example below :
```yaml
# config/packages/dedi_sylius_mail_admin_plugin.yaml
dedi_sylius_mail_admin:
    mails:
        my_first_mail_code:
            variables:
                my_variable_1:
                    label : translation.key.variable_1
                my_variable_2:
                    label : translation.key.variable_2
```

### Add plugin class to your bundles.php :
```php
<?php
$bundles = [
    // ...
    Dedi\SyliusMailAdminPlugin\DediSyliusMailAdminPlugin::class => ['all' => true],
    // ...
];

```

### Add configuration :

```yaml
# config/packages/_sylius.yaml
imports:
    ...
    - { resource: "@DediSyliusMailAdminPlugin/Resources/config/config.yaml" }
```

```yaml
# config/routes.yaml
dedi_sylius_mail_admin_plugin_admin:
    resource: "@DediSyliusMailAdminPlugin/Resources/config/admin_routing.yml"
    prefix: /admin

dedi_sylius_mail_admin_plugin_shop:
    resource: "@DediSyliusMailAdminPlugin/Resources/config/shop_routing.yml"
    prefix: /{_locale}
    requirements:
        _locale: ^[a-z]{2}(?:_[A-Z]{2})?$
```

### Implement your own TrackingUrlFactory and register it :

```yaml
# config/services.yaml
dedi_sylius_mail_admin.factory.tracking_url:
    class: 'Path\To\TrackingUrlFactory'
```

### Customize your email template :

at `src/Resources/views/shared/mail/layout.html.twig`

### Update your database :

```bash
$ bin/console doctrine:migrations:diff
$ bin/console doctrine:migrations:migrate
```

### Install assets :

```bash
$ bin/console assets:install
$ bin/console sylius:theme:assets:install
```

### Clear cache :

```bash
$ bin/console cache:clear
```
# Contribute

## Documentation

- [About the handlers](docs/HANDLERS.md)

For a comprehensive guide on Sylius Plugins development please go to Sylius documentation,
there you will find the <a href="https://docs.sylius.com/en/latest/plugin-development-guide/index.html">Plugin Development Guide</a>, that is full of examples.

## Quickstart Installation

```bash
$ make start
$ make db-create
$ make db-update
$ make fixtures

$ make build
$ make assets
```

## Usage

### Running plugin tests

  - PHPUnit

    ```bash
    $ vendor/bin/phpunit
    ```

  - PHPSpec

    ```bash
    $ vendor/bin/phpspec run
    ```

  - Behat (non-JS scenarios)

    ```bash
    $ vendor/bin/behat --tags="~@javascript"
    ```

  - Behat (JS scenarios)
 
    1. Download [Chromedriver](https://sites.google.com/a/chromium.org/chromedriver/)
    
    2. Download [Selenium Standalone Server](https://www.seleniumhq.org/download/).
    
    2. Run Selenium server with previously downloaded Chromedriver:
    
        ```bash
        $ java -Dwebdriver.chrome.driver=chromedriver -jar selenium-server-standalone.jar
        ```
        
    3. Run test application's webserver on `localhost:8080`:
    
        ```bash
        $ (cd tests/Application && bin/console server:run localhost:8080 -d public -e test)
        ```
    
    4. Run Behat:
    
        ```bash
        $ vendor/bin/behat --tags="@javascript"
        ```

### Opening Sylius with your plugin

- Using `test` environment:

    ```bash
    $ (cd tests/Application && bin/console sylius:fixtures:load -e test)
    $ (cd tests/Application && bin/console server:run -d public -e test)
    ```
    
- Using `dev` environment:

    ```bash
    $ (cd tests/Application && bin/console sylius:fixtures:load -e dev)
    $ (cd tests/Application && bin/console server:run -d public -e dev)
    ```
