<?php

declare(strict_types=1);

namespace Tests\Dedi\SyliusContactPlugin\Behat\Page\Admin\Request;

use Behat\Mink\Element\NodeElement;
use Sylius\Behat\Behaviour\Toggles;

class UpdatePage extends \Sylius\Behat\Page\Admin\Crud\UpdatePage implements UpdatePageInterface
{
    use Toggles;

    protected function getToggleableElement(): NodeElement
    {
        return $this->getElement('enabled');
    }

    public function getLabel(string $language): string
    {
        return $this->getElement('label', ['%language%' => $language])->getValue();
    }

    public function getRecipientEmail(string $language): string
    {
        return $this->getElement('recipient_email', ['%language%' => $language])->getValue();
    }

    public function getRank(): string
    {
        return $this->getElement('rank')->getValue();
    }

    public function isEnabled(): bool
    {
        return $this->getToggleableElement()->isChecked();
    }

    protected function getDefinedElements(): array
    {
        return array_merge(parent::getDefinedElements(), [
            'enabled' => '#dedi_sylius_contact_form_subject_active',
            'label' => '#dedi_sylius_contact_form_subject_translations_%language%_label',
            'recipient_email' => '#dedi_sylius_contact_form_subject_translations_%language%_recipientEmail',
            'rank' => '#dedi_sylius_contact_form_subject_subjectRank',
        ]);
    }
}
