<?php

declare(strict_types=1);

namespace Tests\Dedi\SyliusContactPlugin\Behat\Page\Admin\Request;

use Sylius\Behat\Page\Admin\Crud\CreatePage as BaseCreatePage;

class CreatePage extends BaseCreatePage implements CreatePageInterface
{
    public function specifyLabelIn(string $label, string $localeCode): void
    {
        $this->getDocument()->fillField(
            sprintf('dedi_sylius_contact_form_subject_translations_%s_label', $localeCode),
            $label,
        );
    }

    public function specifyRecipientEmailIn(string $recipentEmail, string $localeCode): void
    {
        $this->getDocument()->fillField(
            sprintf('dedi_sylius_contact_form_subject_translations_%s_recipientEmail', $localeCode),
            $recipentEmail,
        );
    }

    public function specifySubjectRank(string $subjectRank): void
    {
        $this->getDocument()->fillField(
            'dedi_sylius_contact_form_subject_subjectRank',
            $subjectRank,
        );
    }
}
