<?php

declare(strict_types=1);

namespace Tests\Dedi\SyliusContactPlugin\Behat\Context\Setup;

use Behat\Behat\Context\Context;
use Dedi\SyliusContactPlugin\Entity\ContactFormSubjectInterface;
use Dedi\SyliusContactPlugin\Entity\ContactFormSubjectTranslationInterface;
use Doctrine\ORM\EntityManagerInterface;
use Sylius\Behat\Service\SharedStorageInterface;
use Sylius\Component\Resource\Factory\FactoryInterface;

class SubjectContext implements Context
{
    private $subjectFactory;

    private $sharedStorage;

    private $subjectManager;

    public function __construct(
        FactoryInterface $subjectFactory,
        SharedStorageInterface $sharedStorage,
        EntityManagerInterface $subjectManager,
    ) {
        $this->subjectFactory = $subjectFactory;
        $this->sharedStorage = $sharedStorage;
        $this->subjectManager = $subjectManager;
    }

    /**
     * @Given the store has a subject named :name with recipient's email :email in :language
     *
     * @And the store has a subject named :name with recipient's email :email in :language
     */
    public function theStoreHasASubject(string $name, string $email, string $language): void
    {
        $subject = $this->createSubjectWithTranslation($language);
        /** @var ContactFormSubjectTranslationInterface $translation */
        $translation = $subject->getTranslation($language);
        $translation
            ->setLabel($name)
            ->setRecipientEmail($email)
        ;

        $this->sharedStorage->set('subject', $subject);
        $this->subjectManager->persist($subject);
        $this->subjectManager->flush();
    }

    private function createSubjectWithTranslation($language): ContactFormSubjectInterface
    {
        /** @var ContactFormSubjectInterface $subject */
        $subject = $this->subjectFactory->createNew();
        $subject->setCurrentLocale($language);
        $subject->getTranslation($language);

        return $subject;
    }
}
