<?php

declare(strict_types=1);

namespace Dedi\SyliusContactPlugin\Uploader;

use Symfony\Component\HttpFoundation\File\UploadedFile;

class AttachmentFIleUploader implements AttachmentFileUploaderInterface
{
    public function __construct(private readonly string $targetDirectory)
    {
    }

    public function upload(UploadedFile $file): string
    {
        $originalFilename = pathinfo($file->getClientOriginalName(), \PATHINFO_FILENAME);
        $safeFilename = transliterator_transliterate('Any-Latin; Latin-ASCII; [^A-Za-z0-9_] remove; Lower()', $originalFilename);
        $fileName = sprintf(
            '%s-%s.%s',
            $safeFilename,
            uniqid(),
            $file->guessExtension(),
        );

        $file->move($this->targetDirectory, $fileName);

        return sprintf(
            '%s%s%s',
            $this->targetDirectory,
            \DIRECTORY_SEPARATOR,
            $fileName,
        );
    }
}
