<?php

declare(strict_types=1);

namespace Dedi\SyliusContactPlugin\Twig\Component;

use Dedi\SyliusContactPlugin\Entity\ContactFormMessage;
use Dedi\SyliusContactPlugin\Entity\ContactFormMessageInterface;
use Dedi\SyliusContactPlugin\Form\AnswerType;
use Dedi\SyliusContactPlugin\Model\AnswerModel;
use Dedi\SyliusContactPlugin\Repository\ContactFormMessageRepository;
use Sylius\Bundle\UiBundle\Twig\Component\LiveCollectionTrait;
use Sylius\Bundle\UiBundle\Twig\Component\TemplatePropTrait;
use Sylius\TwigHooks\LiveComponent\HookableLiveComponentTrait;
use Symfony\Bundle\SecurityBundle\Security;
use Symfony\Component\Form\FormFactoryInterface;
use Symfony\Component\Form\FormInterface;
use Symfony\UX\LiveComponent\Attribute\AsLiveComponent;
use Symfony\UX\LiveComponent\Attribute\LiveProp;
use Symfony\UX\LiveComponent\ComponentWithFormTrait;
use Symfony\UX\LiveComponent\DefaultActionTrait;

#[AsLiveComponent]
class AnswerFormComponent
{
    use DefaultActionTrait;
    use LiveCollectionTrait;
    use ComponentWithFormTrait;
    use TemplatePropTrait;
    use HookableLiveComponentTrait;

    #[LiveProp(hydrateWith: 'hydrateMessage', dehydrateWith: 'dehydrateMessage')]
    public ContactFormMessage $message;

    #[LiveProp(hydrateWith: 'hydrateAnswerModel', dehydrateWith: 'dehydrateAnswerModel')]
    public ?AnswerModel $answerModel = null;

    public function __construct(
        private readonly ContactFormMessageRepository $contactFormMessageRepository,
        private readonly FormFactoryInterface $formFactory,
        private readonly Security $security,
    ) {
    }

    public function hydrateMessage(int|null $value): ?ContactFormMessageInterface
    {
        if (null === $value) {
            return new ContactFormMessage();
        }

        return $this->contactFormMessageRepository->find($value);
    }

    public function dehydrateMessage(ContactFormMessageInterface|null $message): int|null
    {
        return $message?->getId();
    }

    public function hydrateAnswerModel(int|null $data): AnswerModel
    {
        if (null === $data) {
            $message = $this->message;
        } else {
            $message = $this->contactFormMessageRepository->find($data);
        }

        return new AnswerModel(
            $message,
            $this->security->getUser(),
        );
    }

    public function dehydrateAnswerModel(AnswerModel|null $data): ?int
    {
        return $data?->contactFormMessage?->getId();
    }

    protected function instantiateForm(): FormInterface
    {
        return $this->formFactory->create(AnswerType::class, $this->answerModel);
    }
}
