<?php

declare(strict_types=1);

namespace Dedi\SyliusContactPlugin\Twig;

use Twig\Extension\AbstractExtension;
use Twig\TwigFilter;

class BasenameExtension extends AbstractExtension
{
    public function getFilters()
    {
        return [
            new TwigFilter('dedi_sylius_contact_form_basename', [$this, 'getBasename']),
        ];
    }

    public function getBasename(string $path): string
    {
        return basename($path);
    }
}
