<?php

declare(strict_types=1);

namespace Dedi\SyliusContactPlugin\Repository;

use Dedi\SyliusContactPlugin\Entity\ContactFormSubject;
use Doctrine\ORM\QueryBuilder;
use Sylius\Component\Resource\Repository\RepositoryInterface;

interface ContactFormSubjectRepositoryInterface extends RepositoryInterface
{
    public function createTranslationBasedQueryBuilder(?string $locale = null): QueryBuilder;

    public function findOneActiveTranslatableById(int $id, string $locale): ?ContactFormSubject;

    public function hasMultipleContactFormMessage(): bool;
}
