<?php

declare(strict_types=1);

namespace Dedi\SyliusContactPlugin\Repository;

use Dedi\SyliusContactPlugin\Entity\ContactFormSubject;
use Doctrine\ORM\NonUniqueResultException;
use Doctrine\ORM\QueryBuilder;
use Sylius\Bundle\ResourceBundle\Doctrine\ORM\EntityRepository;

class ContactFormSubjectRepository extends EntityRepository implements ContactFormSubjectRepositoryInterface
{
    public function createTranslationBasedQueryBuilder(?string $locale = null): QueryBuilder
    {
        $queryBuilder = $this->createQueryBuilder('o')
            ->addSelect('translation')
            ->innerJoin('o.translations', 'translation', 'WITH', 'translation.locale = :locale')
        ;

        if (null !== $locale) {
            $queryBuilder
                ->andWhere('translation.locale = :locale')
                ->setParameter('locale', $locale)
            ;
        }

        return $queryBuilder;
    }

    /**
     * @throws NonUniqueResultException
     */
    public function findOneActiveTranslatableById(int $id, string $locale): ?ContactFormSubject
    {
        return $this
            ->createTranslationBasedQueryBuilder($locale)
            ->andWhere('o.id = :id')
            ->andWhere('o.active = :active')
            ->setParameter('id', $id)
            ->setParameter('active', 1)
            ->setMaxResults(1)
            ->getQuery()
            ->getOneOrNullResult()
        ;
    }

    public function hasMultipleContactFormMessage(): bool
    {
        return $this->createQueryBuilder('c')
                ->select('COUNT(c.id)')
                ->andWhere('c.active = :active')
                ->setParameter('active', true)
                ->getQuery()
                ->getSingleScalarResult() > 1;
    }
}
