<?php

declare(strict_types=1);

namespace Dedi\SyliusContactPlugin\Model;

use Dedi\SyliusContactPlugin\Entity\ContactFormMessageInterface;
use Sylius\Component\Core\Model\AdminUserInterface;
use Symfony\Component\HttpFoundation\File\UploadedFile;

class AnswerModel
{
    public ContactFormMessageInterface $contactFormMessage;

    public AdminUserInterface $author;

    public bool $process;

    public ?string $message;

    /** @var UploadedFile[] */
    public array $attachments;

    public function __construct(
        ContactFormMessageInterface $contactFormMessage,
        AdminUserInterface $author,
    ) {
        $this->contactFormMessage = $contactFormMessage;
        $this->author = $author;
        $this->process = false;
        $this->message = '';
        $this->attachments = [];
    }
}
