<?php

declare(strict_types=1);

namespace Dedi\SyliusContactPlugin\Mailer;

use Dedi\SyliusContactPlugin\Entity\AttachmentInterface;
use Dedi\SyliusContactPlugin\Entity\ContactFormMessageInterface;
use Sylius\Component\Channel\Context\ChannelContextInterface;
use Sylius\Component\Locale\Context\LocaleContextInterface;
use Sylius\Component\Mailer\Sender\SenderInterface;

class CustomerContactRequestMailer implements CustomerContactRequestMailerInterface
{
    public function __construct(
        private readonly SenderInterface $mailer,
        private readonly LocaleContextInterface $localeContext,
        private readonly ChannelContextInterface $channelContext,
    ) {
    }

    public function send(ContactFormMessageInterface $message): void
    {
        $this->mailer->send(
            self::EMAIL_CODE,
            [$message->getEmail()],
            [
                'contactMessage' => $message,
                'localeCode' => $this->localeContext->getLocaleCode(),
                'channel' => $this->channelContext->getChannel(),
            ],
            array_map(fn (AttachmentInterface $attachment) => $attachment->getPath(), $message->getAttachments()->toArray()),
        );
    }
}
