<?php

declare(strict_types=1);

namespace Dedi\SyliusContactPlugin\Mailer;

use Dedi\SyliusContactPlugin\Entity\AnswerInterface;
use Dedi\SyliusContactPlugin\Entity\AttachmentInterface;
use Sylius\Component\Channel\Context\ChannelContextInterface;
use Sylius\Component\Locale\Context\LocaleContextInterface;
use Sylius\Component\Mailer\Sender\SenderInterface;

class AnswerMailer implements AnswerMailerInterface
{
    public function __construct(
        private readonly SenderInterface $mailer,
        private readonly LocaleContextInterface $localeContext,
        private readonly ChannelContextInterface $channelContext,
    ) {
    }

    public function send(
        AnswerInterface $answer,
    ): void {
        $this->mailer->send(self::MAIL_CODE, [$answer->getContactFormMessage()->getEmail()], [
            'answer' => $answer,
            'contactMessage' => $answer->getContactFormMessage(),
            'localeCode' => $this->localeContext->getLocaleCode(),
            'channel' => $this->channelContext->getChannel(),
        ], array_map(fn (AttachmentInterface $attachment) => $attachment->getPath(), $answer->getAttachments()->toArray()));
    }
}
