<?php

declare(strict_types=1);

namespace Dedi\SyliusContactPlugin\Form;

use Sylius\Bundle\ResourceBundle\Form\EventSubscriber\AddCodeFormSubscriber;
use Sylius\Bundle\ResourceBundle\Form\Type\AbstractResourceType;
use Sylius\Bundle\ResourceBundle\Form\Type\ResourceTranslationsType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Validator\Constraints\NotBlank;
use Symfony\Component\Validator\Constraints\Valid;

class ContactFormSubjectType extends AbstractResourceType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->addEventSubscriber(new AddCodeFormSubscriber())
            ->add('subjectRank', NumberType::class, [
                'label' => 'dedi_sylius_contact_form.ui.form.subject_rank',
                'constraints' => [
                    new NotBlank(['groups' => ['default', 'sylius']]),
                ],
                'html5' => true,
            ])
            ->add('active', CheckboxType::class, [
                'label' => 'dedi_sylius_contact_form.ui.form.active',
            ])
            ->add('translations', ResourceTranslationsType::class, [
                'entry_type' => ContactFormSubjectTranslationType::class,
                'constraints' => [new Valid()],
                'label' => false,
                'error_bubbling' => false,
            ])
        ;
    }

    public function getBlockPrefix(): string
    {
        return 'dedi_sylius_contact_form_subject';
    }
}
