<?php

declare(strict_types=1);

namespace Dedi\SyliusContactPlugin\Form;

use Sylius\Bundle\ResourceBundle\Form\Type\AbstractResourceType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;

class ContactFormSubjectTranslationType extends AbstractResourceType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('label', TextType::class, [
                'label' => 'dedi_sylius_contact_form.ui.form.label',
                'required' => true,
            ])
            ->add('recipientEmail', EmailType::class, [
                'label' => 'dedi_sylius_contact_form.ui.form.recipient_email',
                'required' => true,
            ])
        ;
    }

    public function getBlockPrefix(): string
    {
        return 'dedi_sylius_contact_form_subject_translation';
    }
}
