<?php

declare(strict_types=1);

namespace Dedi\SyliusContactPlugin\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints\File;
use Symfony\Component\Validator\Constraints\NotNull;
use Symfony\Contracts\Translation\TranslatorInterface;

final class AttachmentType extends AbstractType
{
    public function __construct(
        private readonly TranslatorInterface $translator,
        private readonly string $helpExtensions,
        private readonly string $maxSize,
        private readonly array $mimeTypes,
    ) {
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $allowedExtensionsMessage = $this->translator->trans('dedi_sylius_contact_form.ui.form.attachment_help', [
            '%extensions%' => $this->helpExtensions,
        ]);

        $resolver->setDefaults([
            'label' => 'dedi_sylius_contact_form.ui.form.attachment',
            'required' => false,
            'help' => $allowedExtensionsMessage,
            'constraints' => [
                new NotNull([
                    'groups' => ['default', 'sylius'],
                ]),
                new File([
                    'maxSize' => $this->maxSize,
                    'mimeTypes' => $this->mimeTypes,
                    'groups' => ['default', 'sylius'],
                    'mimeTypesMessage' => $allowedExtensionsMessage,
                ]),
            ],
            'validation_groups' => ['default', 'sylius'],
        ]);
    }

    public function getParent()
    {
        return FileType::class;
    }
}
