<?php

declare(strict_types=1);

namespace Dedi\SyliusContactPlugin\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints\Count;
use Symfony\Contracts\Translation\TranslatorInterface;
use Symfony\UX\LiveComponent\Form\Type\LiveCollectionType;

final class AttachmentCollectionType extends AbstractType
{
    public function __construct(
        private readonly TranslatorInterface $translator,
        private readonly string $helpExtensions,
        private readonly int $maxAttachment,
    ) {
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $allowedExtensionsMessage = $this->translator->trans('dedi_sylius_contact_form.ui.form.attachment_help', [
            '%extensions%' => $this->helpExtensions,
        ]);

        $resolver->setDefaults([
            'label' => 'dedi_sylius_contact_form.ui.form.attachments',
            'required' => false,
            'entry_type' => AttachmentType::class,
            'error_bubbling' => false,
            'allow_add' => true,
            'allow_delete' => true,
            'help' => $allowedExtensionsMessage,
            'constraints' => [
                new Count([
                    'max' => $this->maxAttachment,
                    'groups' => ['default', 'sylius'],
                ]),
            ],
            'validation_groups' => ['default', 'sylius'],
        ]);
    }

    public function getParent()
    {
        return LiveCollectionType::class;
    }
}
